//
//  cffLib.h
//  GSFontTools
//
//  Created by Georg Seifert on 29.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
//#import "cffIndexes.h"
//#import "cffConverter.h"
#import <GSFontTools/TTFont.h>
@class GSXMLWriter;
@class CFFPrivateDict;
@class CFFTopDictIndex;
@class CFFIndexedStrings;
@class CFFGlobalSubrsIndex;
@class CFFSubrsIndex;
@class CFFIndexCompiler;
@class CFFFDArrayIndex;
@class CFFFDSelect;
@class GSFileData;
@class OTOrderedDictionary;

#define kBlendDictOpName @"blend"
#define blendOp = 23

//@interface cffLib : NSObject {
//
//}
//
//@end

@interface CFFFontSet : NSObject {
	char _major;
	char _minor;
	char _hdrSize;
	char _offSize;
	uint16 _topDictSize;
	NSArray *_fontNames;
	CFFTopDictIndex *_topDictIndex;
	CFFIndexedStrings *_strings;
	CFFGlobalSubrsIndex *_globalSubrs;
}

@property (retain, nonatomic) NSArray *fontNames;
@property (readonly, nonatomic) CFFTopDictIndex *topDictIndex;

- (BOOL)decompile:(GSFileData *)Data font:(TTFont *)Font error:(NSError **)error;

- (NSUInteger)count;

- (NSArray *)allKeys;
//- (TopDictIndex*) allValues;
- (void)compile:(NSMutableData *)Data font:(TTFont *)Font isCFF2:(BOOL)isCFF2;

- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content;
- (void)toXML:(GSXMLWriter *)Writer;
@end

@interface CFFWriter : NSObject
@end

@interface CFFCharStrings : NSObject <GlyphSet> {
	CFFGlobalSubrsIndex *_globalSubrs;
	CFFPrivateDict *_private;
	CFFFDSelect *_fdSelect;
	CFFFDArrayIndex *_fdArray;
	NSArray *_fdSelectIndex;
	CFFSubrsIndex *_charStringsIndex;
	OTOrderedDictionary *_charStrings;
	BOOL _charStringsAreIndexed;
}

- (id)initWithFile:(GSFileData *)File charset:(NSArray *)Charset globalSubrs:(CFFGlobalSubrsIndex *)GlobalSubrs private:(CFFPrivateDict *)Private fdSelect:(CFFFDSelect *)FdSelect fdArray:(CFFFDArrayIndex *)FdArray;

- (id)glyphForName:(NSString *)Name;

- (id)selectorForName:(NSString *)Name;
@end

@interface CFFIndexedStrings : NSObject {
	NSMutableArray *_strings;
	NSMutableDictionary *_stringMapping;
}

@property (retain, nonatomic) NSMutableArray *strings;

- (id)initWithFile:(GSFileData *)File;

- (CFFIndexCompiler *)compiler;

- (NSUInteger)count;

- (id)stringForSID:(NSUInteger)SID;
@end

@interface CFFFDSelect : NSObject {
	NSUInteger _format;
	NSMutableDictionary *_gidArray;
}

- (id)initWithFile:(GSFileData *)File numGlyphs:(NSUInteger)NumGlyphs format:(NSUInteger)Format;

- (NSUInteger)count;

- (id)objectAtIndex:(NSUInteger)aIndex;
@end
